#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


setwd("E:\\metabolism\\LGG\\17.Model_gene\\3.Survival")   
#library packages
library(limma)
library(survival)
library(survminer)

###############
rt1=read.table('uniCox.OS.TCGA.txt',header = T)
rt2=read.table('uniCox.PFI.TCGA.txt',header = T)
rt3=read.table('uniCox.DSS.TCGA.txt',header = T)
rt4=read.table('uniCox.OS.CGGA.txt',header = T)
rt5=read.table('uniCox.OS.Rembrandt.txt',header = T)

rt1$Dataset='TCGA-OS'
rt2$Dataset='TCGA-PFI'
rt3$Dataset='TCGA-DSS'
rt4$Dataset='CGGA-OS'
rt5$Dataset='Rembrandt-OS'


rt=rbind(rt1,rt2,rt3,rt4,rt5)
rt$`-logP`=-log(rt$pvalue,10)
rt$logHR=log(rt$HR,10)*10
library(ggplot2)
rt$logHR=ifelse(rt$logHR>3,3,rt$logHR)
rt$logHR=ifelse(rt$logHR< -3,-3,rt$logHR)

ggplot(data=rt)+
  geom_point(aes(y=Dataset,x=id,fill=logHR,size=`-logP`),
             color='black',shape=21,stroke=1.5)+
  scale_fill_gradientn(colours = c('#403D76','#E3B635','#C02E20'),limits=c(-3,3))+
  theme_bw()+
  theme(axis.text.x=element_text(angle=60,hjust=1),
        panel.grid.major =element_blank(), 
        panel.grid.minor = element_blank())+
  scale_size_area(breaks=c(5,10,15,20))